VERSION 5.00
Object = "{529CEB83-B6C0-11D6-BD0E-00B0D0541EE4}#1.0#0"; "SSICON~1.OCX"
Begin VB.Form Form1 
   Caption         =   "Scan Engine Demo"
   ClientHeight    =   5685
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6735
   LinkTopic       =   "Form1"
   ScaleHeight     =   5685
   ScaleWidth      =   6735
   StartUpPosition =   3  'Windows Default
   Begin SSICONNECTLib.SSIConnect SSIConnect1 
      Height          =   480
      Left            =   5160
      TabIndex        =   19
      Top             =   4680
      Width           =   480
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      ComPortNumber   =   1
      BaudRate        =   9600
      BeepCode        =   2
      SendMacroPDFDataOnAbort=   0   'False
      ParameterPersistance=   0   'False
      ImageFilename   =   """hello"""
   End
   Begin VB.CommandButton CommandRelease 
      Caption         =   "Release Trigger"
      Height          =   495
      Left            =   2640
      TabIndex        =   17
      Top             =   4800
      Width           =   1695
   End
   Begin VB.Frame Frame1 
      Caption         =   "Connection Setup"
      Height          =   1575
      Left            =   240
      TabIndex        =   10
      Top             =   0
      Width           =   5535
      Begin VB.TextBox ComPort 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   375
         Left            =   1680
         TabIndex        =   16
         Text            =   "Text4"
         Top             =   720
         Width           =   1335
      End
      Begin VB.TextBox BaudRate 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   375
         Left            =   1680
         TabIndex        =   13
         Text            =   "Text3"
         Top             =   240
         Width           =   1335
      End
      Begin VB.CommandButton CommandDisconnect 
         Caption         =   "Disconnect"
         Height          =   495
         Left            =   3480
         TabIndex        =   12
         Top             =   840
         Width           =   1335
      End
      Begin VB.CommandButton CommandConnect 
         Caption         =   "Connect"
         Height          =   495
         Left            =   3480
         TabIndex        =   11
         Top             =   240
         Width           =   1335
      End
      Begin VB.Label Label6 
         Alignment       =   1  'Right Justify
         Caption         =   "Com Port:"
         Height          =   255
         Left            =   600
         TabIndex        =   15
         Top             =   720
         Width           =   855
      End
      Begin VB.Label Label4 
         Alignment       =   1  'Right Justify
         Caption         =   "Baud Rate:"
         Height          =   255
         Left            =   120
         TabIndex        =   14
         Top             =   360
         Width           =   1335
      End
   End
   Begin VB.CommandButton CommandPull 
      Caption         =   "Pull Trigger"
      Height          =   495
      Left            =   720
      TabIndex        =   9
      Top             =   4800
      Width           =   1455
   End
   Begin VB.TextBox Text2 
      Height          =   375
      Left            =   2280
      TabIndex        =   3
      Text            =   "Text2"
      Top             =   5880
      Width           =   975
   End
   Begin VB.TextBox ParamNumber 
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      Height          =   375
      Left            =   2160
      TabIndex        =   2
      Text            =   "138"
      Top             =   2280
      Width           =   975
   End
   Begin VB.Frame Parameters 
      BackColor       =   &H8000000A&
      Caption         =   "Parameters:"
      Height          =   1695
      Left            =   120
      TabIndex        =   4
      Top             =   1800
      Width           =   5535
      Begin VB.TextBox ParamValue 
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   375
         Left            =   2040
         TabIndex        =   18
         Text            =   "8"
         Top             =   1080
         Width           =   975
      End
      Begin VB.CommandButton CommandGetParam 
         Caption         =   "Get Parameter Value"
         Height          =   495
         Left            =   3240
         TabIndex        =   8
         Top             =   360
         Width           =   1695
      End
      Begin VB.CommandButton CommandChangeParam 
         Caption         =   "Change Parameter"
         Height          =   495
         Left            =   3240
         TabIndex        =   7
         Top             =   1080
         Width           =   1695
      End
      Begin VB.Label Label3 
         Alignment       =   1  'Right Justify
         Caption         =   "Parameter Value:"
         Height          =   255
         Left            =   240
         TabIndex        =   6
         Top             =   1080
         Width           =   1455
      End
      Begin VB.Label Label5 
         Alignment       =   1  'Right Justify
         Caption         =   "Parameter Number:"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   600
         Width           =   1575
      End
   End
   Begin VB.Label DecodeData 
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   4080
      Width           =   6255
   End
   Begin VB.Label Label1 
      Caption         =   "Decode Data:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   3720
      Width           =   1095
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim ScannerSetup As Boolean
Dim bHostTriggerMode As Boolean
Dim bSSIDecodeDataFormat As Boolean









Private Sub CommandChangeParam_Click()
Dim p As Long
Dim v As Long
Dim b As Boolean

b = False
p = ParamNumber
v = ParamValue

If p >= 0 And v >= 0 Then
b = SSIConnect1.ChangeParameter(p, v)
End If

If b <> False Then
ParamValue = Str(v)
Else
DecodeData = "Parameter Not Retrieved"
End If

End Sub

Private Sub CommandConnect_Click()
SSIConnect1.ComPortNumber = ComPort
SSIConnect1.BaudRate = BaudRate
b = SSIConnect1.ConnectComPort

If b Then
DecodeData = "Error Connecting Com Port"
Else
DecodeData = "Connected"
Call CommandChangeParam_Click  ' put scanner in host mode by changing parameter
End If

End Sub

Private Sub CommandDisconnect_Click()
b = SSIConnect1.DisconnectComPort
If b Then
DecodeData = "Error Disconnecting"
Else
DecodeData = Disconnected
End If

ScannerSetup = False
bHostTriggerMode = False
bSSIDecodeDataFormat = False

ParamNumber = Str(138)
ParamValue = Str(8)

End Sub

Private Sub CommandGetParam_Click()
Dim p As Long
Dim b As Boolean
Dim Val As Long


b = False
p = ParamNumber

If p >= 0 Then
b = SSIConnect1.RequestParameter(p)
End If

If b <> False Then
DecodeData = "Request for Parameter Denied"
Else
DecodeData = "Request Sent Successfully"
End If




End Sub

Private Sub CommandPull_Click()
SSIConnect1.SendCommand (ssiSWTriggerPull)
End Sub

Private Sub CommandRelease_Click()
SSIConnect1.SendCommand (ssiSWTriggerRelease)
End Sub

Private Sub Form_Load()
ScannerSetup = False
bHostTriggerMode = False
bSSIDecodeDataFormat = False

ComPort = SSIConnect1.ComPortNumber
BaudRate = SSIConnect1.BaudRate
End Sub

Private Sub SSIConnect1_DecodeDataAvailable(ByVal Length As Long)
Dim b As Long
Dim code As Integer

Dim Data As Variant

b = SSIConnect1.GetDecodeData(Data, vbString, code)


If b > 0 Then
DecodeData = Data
Else
DecodeData = "Zero Length Decode Data"
End If

End Sub

Private Sub SSIConnect1_ParameterAvailable()
Dim p As Long
Dim Val As Long
Dim b As Boolean

p = ParamNumber



b = SSIConnect1.GetParameter(p, Val)
If b Then
ParamValue = Str(Val)
Else
DecodeData = "Parameter Not Supported"
End If

End Sub

Private Sub SSIConnect1_ScannerStatusAvailable(ByVal StatusCode As Long)


If StatusCode = 0 Then
    DecodeData = "Good Status From Scanner"

    Dim p As Long

    p = ParamNumber

    If ScannerSetup = False Then
        If bHostTriggerMode Then  ' we got our response from our first request last time
            If p = 238 Then        ' this time we're waiting for decode data format
                bSSIDecodeDataFormat = True
                ScannerSetup = True
                ParamNumber = "0"
                ParamValue = "0"
                DecodeData = "Host Trigger Mode is set and Decode Data set to  SSI Packets"
            End If
        Else
            If p = 138 Then ' we got our request for host trigger mode
                ParamNumber = Str(238)
                ParamValue = Str(1)
                Call CommandChangeParam_Click
                bHostTriggerMode = True
            End If
        End If
    End If
Else
    DecodeData = "Error Or Timeout " + Str(StatusCode) + " From Scanner"
End If



End Sub


